(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 4.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     46606,       1217]*)
(*NotebookOutlinePosition[     47243,       1239]*)
(*  CellTagsIndexPosition[     47199,       1235]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  "Generate Code: Chapter 4\n",
  StyleBox["CCRoss 11/17/2003",
    FontSize->14]
}], "Subtitle"],

Cell[CellGroupData[{

Cell["\[Section]4.2", "Section"],

Cell[CellGroupData[{

Cell["Ex. 4.9", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    \(DSolve[{\(x'\)[t] \[Equal] 3\/2 - 5  x[t]\/\(1000 + t\), 
        x[0] \[Equal] 50}, x[t], t]\)], "Input"],

Cell[BoxData[
    \({{x[
            t] \[Rule] \(\(1\/\(4\ \((1000 + t)\)\^5\)\)\((200000000000000000 \
+ 6000000000000000\ t + 15000000000000\ t\^2 + 20000000000\ t\^3 + 
              15000000\ t\^4 + 6000\ t\^5 + t\^6)\)\)}}\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Soln[t_] = Apart[x[t] /. First[%]\ ]\)], "Input"],

Cell[BoxData[
    \(250 + t\/4 - 200000000000000000\/\((1000 + t)\)\^5\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Simplify[\(Soln'\)[t] - \((3\/2 - 5  Soln[t]\/\(1000 + t\))\) \[Equal] 
        0\ ]\)], "Input"],

Cell[BoxData[
    \(True\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Soln[0] \[Equal] 50\)], "Input"],

Cell[BoxData[
    \(True\)], "Output"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["\[Section]4.3", "Section"],

Cell[BoxData[
    \(Clear[y]\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[{\(y'\)[t] \[Equal] \((1 - y[t])\) \((0.50  t + y[t]\/10)\), 
        y[0] \[Equal] 0.01}, y[t], {t, 0, 5}]\)], "Input"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{\(y[t]\), "\[Rule]", 
          RowBox[{
            TagBox[\(InterpolatingFunction[{{0.`, 5.`}}, "<>"]\),
              False,
              Editable->False], "[", "t", "]"}]}], "}"}], "}"}]], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(p1 = Plot[Evaluate[y[t] /. %[\([1]\)]\ \ ], {t, 0, 5}];\)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.190476 0.0147151 0.589415 [
[.21429 .00222 -3 -9 ]
[.21429 .00222 3 0 ]
[.40476 .00222 -3 -9 ]
[.40476 .00222 3 0 ]
[.59524 .00222 -3 -9 ]
[.59524 .00222 3 0 ]
[.78571 .00222 -3 -9 ]
[.78571 .00222 3 0 ]
[.97619 .00222 -3 -9 ]
[.97619 .00222 3 0 ]
[.01131 .1326 -18 -4.5 ]
[.01131 .1326 0 4.5 ]
[.01131 .25048 -18 -4.5 ]
[.01131 .25048 0 4.5 ]
[.01131 .36836 -18 -4.5 ]
[.01131 .36836 0 4.5 ]
[.01131 .48625 -18 -4.5 ]
[.01131 .48625 0 4.5 ]
[.01131 .60413 -6 -4.5 ]
[.01131 .60413 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .01472 m
.21429 .02097 L
s
[(1)] .21429 .00222 0 1 Mshowa
.40476 .01472 m
.40476 .02097 L
s
[(2)] .40476 .00222 0 1 Mshowa
.59524 .01472 m
.59524 .02097 L
s
[(3)] .59524 .00222 0 1 Mshowa
.78571 .01472 m
.78571 .02097 L
s
[(4)] .78571 .00222 0 1 Mshowa
.97619 .01472 m
.97619 .02097 L
s
[(5)] .97619 .00222 0 1 Mshowa
.125 Mabswid
.0619 .01472 m
.0619 .01847 L
s
.1 .01472 m
.1 .01847 L
s
.1381 .01472 m
.1381 .01847 L
s
.17619 .01472 m
.17619 .01847 L
s
.25238 .01472 m
.25238 .01847 L
s
.29048 .01472 m
.29048 .01847 L
s
.32857 .01472 m
.32857 .01847 L
s
.36667 .01472 m
.36667 .01847 L
s
.44286 .01472 m
.44286 .01847 L
s
.48095 .01472 m
.48095 .01847 L
s
.51905 .01472 m
.51905 .01847 L
s
.55714 .01472 m
.55714 .01847 L
s
.63333 .01472 m
.63333 .01847 L
s
.67143 .01472 m
.67143 .01847 L
s
.70952 .01472 m
.70952 .01847 L
s
.74762 .01472 m
.74762 .01847 L
s
.82381 .01472 m
.82381 .01847 L
s
.8619 .01472 m
.8619 .01847 L
s
.9 .01472 m
.9 .01847 L
s
.9381 .01472 m
.9381 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
.02381 .1326 m
.03006 .1326 L
s
[(0.2)] .01131 .1326 1 0 Mshowa
.02381 .25048 m
.03006 .25048 L
s
[(0.4)] .01131 .25048 1 0 Mshowa
.02381 .36836 m
.03006 .36836 L
s
[(0.6)] .01131 .36836 1 0 Mshowa
.02381 .48625 m
.03006 .48625 L
s
[(0.8)] .01131 .48625 1 0 Mshowa
.02381 .60413 m
.03006 .60413 L
s
[(1)] .01131 .60413 1 0 Mshowa
.125 Mabswid
.02381 .04419 m
.02756 .04419 L
s
.02381 .07366 m
.02756 .07366 L
s
.02381 .10313 m
.02756 .10313 L
s
.02381 .16207 m
.02756 .16207 L
s
.02381 .19154 m
.02756 .19154 L
s
.02381 .22101 m
.02756 .22101 L
s
.02381 .27995 m
.02756 .27995 L
s
.02381 .30942 m
.02756 .30942 L
s
.02381 .33889 m
.02756 .33889 L
s
.02381 .39783 m
.02756 .39783 L
s
.02381 .42731 m
.02756 .42731 L
s
.02381 .45678 m
.02756 .45678 L
s
.02381 .51572 m
.02756 .51572 L
s
.02381 .54519 m
.02756 .54519 L
s
.02381 .57466 m
.02756 .57466 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .02061 m
.02499 .02062 L
.02605 .02064 L
.02729 .02067 L
.02846 .02071 L
.03053 .02081 L
.03279 .02096 L
.03527 .02117 L
.0379 .02145 L
.04262 .02209 L
.05205 .02391 L
.06244 .02674 L
.07293 .03046 L
.0842 .03542 L
.10458 .04685 L
.1458 .07895 L
.18551 .11962 L
.22371 .1655 L
.26435 .21889 L
.30348 .27198 L
.34506 .32746 L
.38513 .37773 L
.42368 .42161 L
.46468 .46243 L
.50417 .49564 L
.54214 .52197 L
.58257 .54439 L
.62148 .56113 L
.66284 .57451 L
.70268 .58391 L
.74101 .59042 L
.76079 .593 L
.78179 .59526 L
.81954 .59832 L
.83889 .59949 L
.85975 .60051 L
.8794 .60128 L
.90089 .60195 L
.92004 .60242 L
.94051 .60282 L
.97619 .60332 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003ooooooolQ
ooooo`00Aoooool3o`00033ooooo1Ol0000_ooooo`?o0000<_ooool3o`00033ooooo0ol00007oooo
o`00B?ooool00ol0003oooooooooo`0`ooooo`04o`000?ooooooooooo`0002kooooo00Go0000oooo
ooooooooooooo`00000booooo`03o`000?oooooooooo02kooooo00Go0000ooooooooooooooooo`00
0006ooooo`00B?ooool00ol0003oooooooooo`0aooooo`03o`000?oooooooooo03;ooooo00?o0000
ooooooooool0;Oooool5o`0003?ooooo00?o0000ooooooooool01?ooool004Sooooo00?o0000oooo
ooooool0<_ooool00ol0003oooooooooo`0_ooooo`;o0000<?ooool01?l0003oooooooooool0000d
ooooo`03o`000?oooooooooo00Cooooo0018ooooo`03o`000?oooooooooo02oooooo00Go0000oooo
ooooooooooooo`00000booooo`03o`000?oooooooooo02kooooo00?o0000ooooool00000<?ooool4
o`0000Oooooo0017ooooo`;o0000<Oooool01Ol0003ooooooooooooooooo000002kooooo00Go0000
ooooooooooooooooo`00000aooooo`;o0000<?ooool00ol0003oooooooooo`08ooooo`00B?ooool0
0ol0003oooooooooo`0`ooooo`?o0000<?ooool3o`0003?ooooo00?o0000ooooooooool0;_ooool5
o`0000Kooooo000Eooooo`03o`000?oooooooooo0?oooooo2Oooool001Gooooo00?o0000oooooooo
ool0ooooool9ooooo`005Oooool00ol0003oooooooooo`3oooooo`Wooooo000Eooooo`03o`000?oo
oooooooo0?oooooo2Oooool000ooooooool0000Ao`00007ooooo000Eooooo`03o`000?oooooooooo
00Sooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo
00Sooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo
00Sooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo
00Sooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo
00Sooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo
00Sooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo
00Sooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo
00Sooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo
00Sooooo00?o0000ooooooooool01Oooool001Gooooo2ol0000Yooooo`03o`000?oooooooooo037o
oooo00?o0000ooooooooool0<?ooool00ol0003oooooooooo`0aooooo`03o`000?oooooooooo037o
oooo00?o0000ooooooooool01Oooool001Gooooo00?o0000ooooooooool02?ooool3o`000?gooooo
000Eooooo`03o`000?oooooooooo00_ooooo0_l0003kooooo`005Oooool00ol0003oooooooooo`0=
ooooo`03o`000?oooooooooo0?Sooooo000Eooooo`03o`000?oooooooooo00kooooo0_l0003hoooo
o`005Oooool00ol0003oooooooooo`0@ooooo`;o0000m_ooool001Gooooo0_l0000Cooooo`03o`00
0?oooooooooo0??ooooo000Eooooo`03o`000?oooooooooo01?ooooo0_l0003cooooo`005Oooool0
0ol0003oooooooooo`0Eooooo`03o`000?oooooooooo0?3ooooo000Eooooo`03o`000?oooooooooo
01Kooooo00?o0000ooooooooool0koooool001Gooooo00?o0000ooooooooool05oooool2o`000>oo
oooo000Eooooo`03o`000?oooooooooo01Wooooo00?o0000ooooooooool0k?ooool001Gooooo00?o
0000ooooooooool06_ooool2o`000>cooooo000Eooooo`03o`000?oooooooooo01cooooo00?o0000
ooooooooool0jOooool001Gooooo0_l0000Nooooo`03o`000?oooooooooo0>Sooooo000Eooooo`03
o`000?oooooooooo01kooooo00?o0000ooooooooool0ioooool001Gooooo00?o0000ooooooooool0
7oooool00ol0003oooooooooo`3Vooooo`005Oooool00ol0003oooooooooo`0Pooooo`03o`000?oo
oooooooo0>Gooooo000Eooooo`03o`000?oooooooooo027ooooo00?o0000ooooooooool0i?ooool0
01Gooooo00?o0000ooooooooool08_ooool00ol0003oooooooooo`3Sooooo`005Oooool00ol0003o
ooooooooo`0Sooooo`03o`000?oooooooooo0>;ooooo000Eooooo`03o`000?oooooooooo02Cooooo
00?o0000ooooooooool0hOooool001Gooooo0_l0000Vooooo`03o`000?oooooooooo0>3ooooo000E
ooooo`03o`000?oooooooooo02Kooooo00?o0000ooooooooool0goooool001Gooooo00?o0000oooo
ooooool09oooool00ol0003oooooooooo`3Nooooo`005Oooool00ol0003oooooooooo`0Xooooo`03
o`000?oooooooooo0=gooooo000Eooooo`03o`000?oooooooooo02Wooooo00?o0000ooooooooool0
g?ooool000;ooooo0_l00004ooooo`04o`000?ooooooooooooooo`Go00001?ooool00ol0003ooooo
ooooo`0Yooooo`03o`000?oooooooooo0=cooooo00001Ooooooo0000oooooooooooo000000Sooooo
00Co0000oooooooooooo00001?ooool00ol0003oooooooooo`0Zooooo`03o`000?oooooooooo0=_o
oooo00001Ooooooo0000oooooooooooo000000Wooooo00?o0000ooooooooool01?ooool00ol0003o
ooooooooo`0[ooooo`03o`000?oooooooooo0=[ooooo00001Ooooooo0000oooooooooooo000000[o
oooo00?o0000ooooooooool00oooool3o`0002cooooo00?o0000ooooooooool0fOooool00005oooo
ool0003oooooooooool000001oooool01Ol0003ooooooooooooooooo000000Cooooo00?o0000oooo
ooooool0;?ooool00ol0003oooooooooo`3Iooooo`0000Goooooo`000?ooooooooooo`000007oooo
o`05o`000?ooooooooooooooool000001?ooool00ol0003oooooooooo`0]ooooo`03o`000?oooooo
oooo0=Sooooo0002ooooo`;o00002Oooool3o`0000Gooooo00?o0000ooooooooool0;_ooool00ol0
003oooooooooo`3Gooooo`005Oooool00ol0003oooooooooo`0_ooooo`03o`000?oooooooooo0=Ko
oooo000Eooooo`03o`000?oooooooooo033ooooo00?o0000ooooooooool0eOooool001Gooooo00?o
0000ooooooooool0<?ooool00ol0003oooooooooo`3Eooooo`005Oooool00ol0003oooooooooo`0a
ooooo`03o`000?oooooooooo0=Cooooo000Eooooo`;o0000<oooool00ol0003oooooooooo`3Coooo
o`005Oooool00ol0003oooooooooo`0cooooo`03o`000?oooooooooo0=;ooooo000Eooooo`03o`00
0?oooooooooo03?ooooo00?o0000ooooooooool0d_ooool001Gooooo00?o0000ooooooooool0=?oo
ool00ol0003oooooooooo`3Aooooo`005Oooool00ol0003oooooooooo`0eooooo`03o`000?oooooo
oooo0=3ooooo000Eooooo`03o`000?oooooooooo03Kooooo00?o0000ooooooooool0coooool001Go
oooo00?o0000ooooooooool0=oooool00ol0003oooooooooo`3>ooooo`005Oooool00ol0003ooooo
ooooo`0gooooo`03o`000?oooooooooo0<kooooo000Eooooo`;o0000>Oooool00ol0003ooooooooo
o`3=ooooo`005Oooool00ol0003oooooooooo`0iooooo`03o`000?oooooooooo0<cooooo000Eoooo
o`03o`000?oooooooooo03[ooooo00?o0000ooooooooool0boooool001Gooooo00?o0000oooooooo
ool0>_ooool00ol0003oooooooooo`3;ooooo`005Oooool00ol0003oooooooooo`0kooooo`03o`00
0?oooooooooo0<[ooooo000Eooooo`03o`000?oooooooooo03cooooo00?o0000ooooooooool0bOoo
ool001Gooooo00?o0000ooooooooool0?Oooool00ol0003oooooooooo`38ooooo`005Oooool00ol0
003oooooooooo`0nooooo`03o`000?oooooooooo0<Oooooo000Eooooo`;o0000?oooool00ol0003o
ooooooooo`37ooooo`005Oooool00ol0003oooooooooo`0oooooo`03o`000?oooooooooo0<Kooooo
000Eooooo`03o`000?oooooooooo043ooooo00?o0000ooooooooool0aOooool001Gooooo00?o0000
ooooooooool0@Oooool00ol0003oooooooooo`34ooooo`005Oooool00ol0003oooooooooo`11oooo
o`03o`000?oooooooooo0<Cooooo0002ooooo`;o00001?ooool00ol0003oooooooooo`03ooooo`?o
00001?ooool00ol0003oooooooooo`12ooooo`03o`000?oooooooooo0<?ooooo00001Ooooooo0000
oooooooooooo000000[ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`13ooooo`03
o`000?oooooooooo0<;ooooo00001Ooooooo0000oooooooooooo000000Oooooo1Ol00004ooooo`03
o`000?oooooooooo04Cooooo00?o0000ooooooooool0`Oooool00005ooooool0003oooooooooool0
00001oooool01?l0003oooooooooool00005ooooo`?o0000A?ooool00ol0003oooooooooo`31oooo
o`0000Goooooo`000?ooooooooooo`000008ooooo`03o`000?oooooo000000Gooooo00?o0000oooo
ooooool0AOooool00ol0003oooooooooo`30ooooo`0000Goooooo`000?ooooooooooo`000009oooo
o`;o00001Oooool00ol0003oooooooooo`16ooooo`03o`000?oooooooooo0;oooooo0002ooooo`;o
00002oooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo04Kooooo00?o0000oooooooo
ool0_oooool001Gooooo00?o0000ooooooooool0Aoooool00ol0003oooooooooo`2nooooo`005Ooo
ool00ol0003oooooooooo`18ooooo`03o`000?oooooooooo0;gooooo000Eooooo`03o`000?oooooo
oooo04Wooooo00?o0000ooooooooool0_?ooool001Gooooo00?o0000ooooooooool0BOooool00ol0
003oooooooooo`2looooo`005Oooool2o`0004_ooooo00?o0000ooooooooool0^oooool001Gooooo
00?o0000ooooooooool0Boooool00ol0003oooooooooo`2jooooo`005Oooool00ol0003ooooooooo
o`1<ooooo`03o`000?oooooooooo0;Wooooo000Eooooo`03o`000?oooooooooo04cooooo00?o0000
ooooooooool0^Oooool001Gooooo00?o0000ooooooooool0COooool00ol0003oooooooooo`2hoooo
o`005Oooool00ol0003oooooooooo`1>ooooo`03o`000?oooooooooo0;Oooooo000Eooooo`03o`00
0?oooooooooo04oooooo00?o0000ooooooooool0]_ooool001Gooooo00?o0000ooooooooool0Cooo
ool00ol0003oooooooooo`2fooooo`005Oooool2o`00057ooooo00?o0000ooooooooool0]Oooool0
01Gooooo00?o0000ooooooooool0DOooool00ol0003oooooooooo`2dooooo`005Oooool00ol0003o
ooooooooo`1Aooooo`03o`000?oooooooooo0;Cooooo000Eooooo`03o`000?oooooooooo05;ooooo
00?o0000ooooooooool0/oooool001Gooooo00?o0000ooooooooool0Doooool00ol0003ooooooooo
o`2booooo`005Oooool00ol0003oooooooooo`1Dooooo`03o`000?oooooooooo0;7ooooo000Eoooo
o`03o`000?oooooooooo05Cooooo00?o0000ooooooooool0/Oooool001Gooooo00?o0000oooooooo
ool0EOooool00ol0003oooooooooo`2`ooooo`005Oooool2o`0005Oooooo00?o0000ooooooooool0
[oooool001Gooooo00?o0000ooooooooool0Eoooool00ol0003oooooooooo`2^ooooo`005Oooool0
0ol0003oooooooooo`1Hooooo`03o`000?oooooooooo0:gooooo000Eooooo`03o`000?oooooooooo
05Sooooo00?o0000ooooooooool0[Oooool001Gooooo00?o0000ooooooooool0FOooool00ol0003o
ooooooooo`2/ooooo`000_ooool2o`0000Cooooo00?o0000ooooooooool00_ooool3o`0000Gooooo
00?o0000ooooooooool0F_ooool00ol0003oooooooooo`2[ooooo`0000Goooooo`000?oooooooooo
o`000007ooooo`05o`000?ooooooooooooooool000001?ooool00ol0003oooooooooo`1Kooooo`03
o`000?oooooooooo0:[ooooo00001Ooooooo0000oooooooooooo000000Oooooo00Go0000oooooooo
ooooooooo`000004ooooo`03o`000?oooooooooo05_ooooo00?o0000ooooooooool0Z_ooool00005
ooooool0003oooooooooool000001oooool4o`0000Gooooo0ol0001Looooo`03o`000?oooooooooo
0:Wooooo00001Ooooooo0000oooooooooooo000000Oooooo00?o0000ooooooooool01_ooool00ol0
003oooooooooo`1Mooooo`03o`000?oooooooooo0:Sooooo00001Ooooooo0000oooooooooooo0000
00Sooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`1Nooooo`03o`000?oooooooooo
0:Oooooo0002ooooo`;o00002_ooool2o`0000Gooooo00?o0000ooooooooool0Goooool00ol0003o
ooooooooo`2Vooooo`005Oooool00ol0003oooooooooo`1Pooooo`03o`000?oooooooooo0:Gooooo
000Eooooo`03o`000?oooooooooo067ooooo00?o0000ooooooooool0Y?ooool001Gooooo00?o0000
ooooooooool0H_ooool00ol0003oooooooooo`2Sooooo`005Oooool00ol0003oooooooooo`1Soooo
o`03o`000?oooooooooo0:;ooooo000Eooooo`;o0000IOooool00ol0003oooooooooo`2Qooooo`00
5Oooool00ol0003oooooooooo`1Uooooo`03o`000?oooooooooo0:3ooooo000Eooooo`03o`000?oo
oooooooo06Kooooo00?o0000ooooooooool0Woooool001Gooooo00?o0000ooooooooool0Ioooool0
0ol0003oooooooooo`2Nooooo`005Oooool00ol0003oooooooooo`1Xooooo`03o`000?oooooooooo
09gooooo000Eooooo`03o`000?oooooooooo06Wooooo00?o0000ooooooooool0W?ooool001Gooooo
00?o0000ooooooooool0J_ooool00ol0003oooooooooo`2Kooooo`005Oooool00ol0003ooooooooo
o`1Zooooo`03o`000?oooooooooo09_ooooo000Eooooo`;o0000K?ooool00ol0003oooooooooo`2J
ooooo`005Oooool00ol0003oooooooooo`1/ooooo`03o`000?oooooooooo09Wooooo000Eooooo`03
o`000?oooooooooo06gooooo00?o0000ooooooooool0V?ooool001Gooooo00?o0000ooooooooool0
K_ooool00ol0003oooooooooo`2Gooooo`005Oooool00ol0003oooooooooo`1_ooooo`03o`000?oo
oooooooo09Kooooo000Eooooo`03o`000?oooooooooo073ooooo00?o0000ooooooooool0UOooool0
01Gooooo00?o0000ooooooooool0LOooool00ol0003oooooooooo`2Dooooo`005Oooool00ol0003o
ooooooooo`1booooo`03o`000?oooooooooo09?ooooo000Eooooo`;o0000M?ooool00ol0003ooooo
ooooo`2Booooo`005Oooool00ol0003oooooooooo`1dooooo`03o`000?oooooooooo097ooooo000E
ooooo`03o`000?oooooooooo07Gooooo0_l0002Aooooo`005Oooool00ol0003oooooooooo`1goooo
o`03o`000?oooooooooo08kooooo000Eooooo`03o`000?oooooooooo07Sooooo00?o0000oooooooo
ool0SOooool000;ooooo0_l00004ooooo`03o`000?oooooooooo00;ooooo0ol00005ooooo`03o`00
0?oooooooooo07Wooooo00?o0000ooooooooool0S?ooool00005ooooool0003oooooooooool00000
1oooool01Ol0003ooooooooooooooooo000000Cooooo00?o0000ooooooooool0N_ooool2o`0008co
oooo00001Ooooooo0000oooooooooooo000000Oooooo00Go0000ooooooooooooooooo`000004oooo
o`03o`000?oooooooooo07cooooo00?o0000ooooooooool0ROooool00005ooooool0003ooooooooo
ool000002?ooool3o`0000Gooooo0ol0001mooooo`03o`000?oooooooooo08Sooooo00001Ooooooo
0000oooooooooooo000000Oooooo00Go0000ooooooooooooooooo`000004ooooo`03o`000?oooooo
oooo07kooooo00?o0000ooooooooool0Qoooool00005ooooool0003oooooooooool000001oooool0
1Ol0003ooooooooooooooooo000000Cooooo00?o0000ooooooooool0Ooooool00ol0003ooooooooo
o`26ooooo`000_ooool2o`0000Wooooo0ol00005ooooo`03o`000?oooooooooo083ooooo0_l00026
ooooo`005Oooool00ol0003oooooooooo`22ooooo`03o`000?oooooooooo08?ooooo000Eooooo`03
o`000?oooooooooo08?ooooo0_l00023ooooo`005Oooool00ol0003oooooooooo`25ooooo`03o`00
0?oooooooooo083ooooo000Eooooo`03o`000?oooooooooo08Kooooo00?o0000ooooooooool0Oooo
ool001Gooooo0_l00028ooooo`;o0000Ooooool001Gooooo00?o0000ooooooooool0ROooool00ol0
003oooooooooo`1looooo`005Oooool00ol0003oooooooooo`2:ooooo`;o0000O?ooool001Gooooo
00?o0000ooooooooool0S?ooool2o`0007[ooooo000Eooooo`03o`000?oooooooooo08kooooo0_l0
001hooooo`005Oooool00ol0003oooooooooo`2@ooooo`03o`000?oooooooooo07Gooooo000Eoooo
o`03o`000?oooooooooo097ooooo0_l0001eooooo`005Oooool00ol0003oooooooooo`2Cooooo`;o
0000Loooool001Gooooo0_l0002Fooooo`;o0000LOooool001Gooooo00?o0000ooooooooool0Uooo
ool3o`0006kooooo000Eooooo`03o`000?oooooooooo09[ooooo0_l0001/ooooo`005Oooool00ol0
003oooooooooo`2Looooo`?o0000JOooool001Gooooo00?o0000ooooooooool0Woooool3o`0006Ko
oooo000Eooooo`03o`000?oooooooooo0:;ooooo0ol0001Sooooo`005Oooool00ol0003ooooooooo
o`2Uooooo`?o0000H?ooool001Gooooo00?o0000ooooooooool0Z?ooool3o`0005gooooo000Eoooo
o`;o0000[?ooool3o`0005[ooooo000Eooooo`03o`000?oooooooooo0:kooooo0ol0001Gooooo`00
5Oooool00ol0003oooooooooo`2aooooo`?o0000E?ooool001Gooooo00?o0000ooooooooool0]?oo
ool8o`0004cooooo000Eooooo`03o`000?oooooooooo0;cooooo2?l00014ooooo`003Oooool3o`00
00Gooooo00?o0000ooooooooool0a?ooool5o`0003oooooo000>ooooo`03o`000?oooooooooo00Co
oooo00?o0000ooooooooool0bOooool@o`0002oooooo000>ooooo`03o`000?oooooooooo00Cooooo
00?o0000ooooooooool0fOoooolFo`0001Wooooo000>ooooo`03o`000?oooooooooo00Cooooo0ol0
003_oooooa;o00001oooool000kooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`3o
ooooo`Wooooo000=ooooo`;o00001_ooool00ol0003oooooooooo`3oooooo`Wooooo000>ooooo`03
o`000?oooooooooo00Cooooo00?o0000ooooooooool0ooooool9ooooo`005Oooool00ol0003ooooo
ooooo`3oooooo`Wooooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.418894, -0.0774391, \
0.019335, 0.00624832}}]
}, Closed]],

Cell[CellGroupData[{

Cell["fig. 4.17", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[{\(y'\)[t] \[Equal] \((1 - y[t])\) \((0.25  t + y[t]\/10)\), 
        y[0] \[Equal] 0.1}, y[t], {t, 0, 5}]\)], "Input"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{\(y[t]\), "\[Rule]", 
          RowBox[{
            TagBox[\(InterpolatingFunction[{{0.`, 5.`}}, "<>"]\),
              False,
              Editable->False], "[", "t", "]"}]}], "}"}], "}"}]], "Output"]
}, Closed]],

Cell[BoxData[
    \(\(p2 = Plot[Evaluate[y[t] /. %[\([1]\)]\ \ ], {t, 0, 5}];\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[{\(y'\)[t] \[Equal] \((1 - y[t])\) \((0.33  t + y[t]\/10)\), 
        y[0] \[Equal] 0.1}, y[t], {t, 0, 5}]\)], "Input"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{\(y[t]\), "\[Rule]", 
          RowBox[{
            TagBox[\(InterpolatingFunction[{{0.`, 5.`}}, "<>"]\),
              False,
              Editable->False], "[", "t", "]"}]}], "}"}], "}"}]], "Output"]
}, Closed]],

Cell[BoxData[
    \(\(p3 = Plot[Evaluate[y[t] /. %[\([1]\)]\ \ ], {t, 0, 5}];\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[{\(y'\)[t] \[Equal] \((1 - y[t])\) \((0.50  t + y[t]\/10)\), 
        y[0] \[Equal] 0.1}, y[t], {t, 0, 5}]\)], "Input"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{\(y[t]\), "\[Rule]", 
          RowBox[{
            TagBox[\(InterpolatingFunction[{{0.`, 5.`}}, "<>"]\),
              False,
              Editable->False], "[", "t", "]"}]}], "}"}], "}"}]], "Output"]
}, Closed]],

Cell[BoxData[
    \(\(p4 = Plot[Evaluate[y[t] /. %[\([1]\)]\ \ ], {t, 0, 5}];\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Show[p2, p3, p4];\)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.190476 0.0147151 0.589328 [
[.21429 .00222 -3 -9 ]
[.21429 .00222 3 0 ]
[.40476 .00222 -3 -9 ]
[.40476 .00222 3 0 ]
[.59524 .00222 -3 -9 ]
[.59524 .00222 3 0 ]
[.78571 .00222 -3 -9 ]
[.78571 .00222 3 0 ]
[.97619 .00222 -3 -9 ]
[.97619 .00222 3 0 ]
[.01131 .13258 -18 -4.5 ]
[.01131 .13258 0 4.5 ]
[.01131 .25045 -18 -4.5 ]
[.01131 .25045 0 4.5 ]
[.01131 .36831 -18 -4.5 ]
[.01131 .36831 0 4.5 ]
[.01131 .48618 -18 -4.5 ]
[.01131 .48618 0 4.5 ]
[.01131 .60404 -6 -4.5 ]
[.01131 .60404 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .01472 m
.21429 .02097 L
s
[(1)] .21429 .00222 0 1 Mshowa
.40476 .01472 m
.40476 .02097 L
s
[(2)] .40476 .00222 0 1 Mshowa
.59524 .01472 m
.59524 .02097 L
s
[(3)] .59524 .00222 0 1 Mshowa
.78571 .01472 m
.78571 .02097 L
s
[(4)] .78571 .00222 0 1 Mshowa
.97619 .01472 m
.97619 .02097 L
s
[(5)] .97619 .00222 0 1 Mshowa
.125 Mabswid
.0619 .01472 m
.0619 .01847 L
s
.1 .01472 m
.1 .01847 L
s
.1381 .01472 m
.1381 .01847 L
s
.17619 .01472 m
.17619 .01847 L
s
.25238 .01472 m
.25238 .01847 L
s
.29048 .01472 m
.29048 .01847 L
s
.32857 .01472 m
.32857 .01847 L
s
.36667 .01472 m
.36667 .01847 L
s
.44286 .01472 m
.44286 .01847 L
s
.48095 .01472 m
.48095 .01847 L
s
.51905 .01472 m
.51905 .01847 L
s
.55714 .01472 m
.55714 .01847 L
s
.63333 .01472 m
.63333 .01847 L
s
.67143 .01472 m
.67143 .01847 L
s
.70952 .01472 m
.70952 .01847 L
s
.74762 .01472 m
.74762 .01847 L
s
.82381 .01472 m
.82381 .01847 L
s
.8619 .01472 m
.8619 .01847 L
s
.9 .01472 m
.9 .01847 L
s
.9381 .01472 m
.9381 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
.02381 .13258 m
.03006 .13258 L
s
[(0.2)] .01131 .13258 1 0 Mshowa
.02381 .25045 m
.03006 .25045 L
s
[(0.4)] .01131 .25045 1 0 Mshowa
.02381 .36831 m
.03006 .36831 L
s
[(0.6)] .01131 .36831 1 0 Mshowa
.02381 .48618 m
.03006 .48618 L
s
[(0.8)] .01131 .48618 1 0 Mshowa
.02381 .60404 m
.03006 .60404 L
s
[(1)] .01131 .60404 1 0 Mshowa
.125 Mabswid
.02381 .04418 m
.02756 .04418 L
s
.02381 .07365 m
.02756 .07365 L
s
.02381 .10311 m
.02756 .10311 L
s
.02381 .16205 m
.02756 .16205 L
s
.02381 .19151 m
.02756 .19151 L
s
.02381 .22098 m
.02756 .22098 L
s
.02381 .27991 m
.02756 .27991 L
s
.02381 .30938 m
.02756 .30938 L
s
.02381 .33885 m
.02756 .33885 L
s
.02381 .39778 m
.02756 .39778 L
s
.02381 .42724 m
.02756 .42724 L
s
.02381 .45671 m
.02756 .45671 L
s
.02381 .51564 m
.02756 .51564 L
s
.02381 .54511 m
.02756 .54511 L
s
.02381 .57458 m
.02756 .57458 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .07365 m
.02605 .07372 L
.02846 .07382 L
.03279 .07405 L
.03793 .07441 L
.04262 .07482 L
.05281 .076 L
.06244 .07746 L
.08265 .08163 L
.10458 .08782 L
.14545 .1038 L
.1848 .12427 L
.22263 .14812 L
.26292 .17727 L
.30169 .20819 L
.34292 .24318 L
.38262 .27799 L
.42082 .31166 L
.46146 .34686 L
.50059 .37943 L
.54217 .41201 L
.58224 .44095 L
.62079 .46624 L
.6618 .49025 L
.70128 .51051 L
.73925 .52741 L
.77968 .54277 L
.81859 .55518 L
.85995 .56609 L
.89979 .57462 L
.93812 .58126 L
.97619 .58655 L
s
.02381 .07365 m
.02605 .07372 L
.02846 .07383 L
.03279 .07409 L
.03793 .07452 L
.04262 .07503 L
.05281 .07649 L
.06244 .07834 L
.08265 .08364 L
.10458 .09157 L
.14545 .11204 L
.1848 .1381 L
.22263 .16811 L
.26292 .20418 L
.30169 .24164 L
.34292 .28294 L
.38262 .32282 L
.42082 .36015 L
.46146 .39776 L
.50059 .43117 L
.54217 .4631 L
.58224 .49011 L
.62079 .51254 L
.6618 .5327 L
.70128 .54874 L
.73925 .56135 L
.77968 .57211 L
.81859 .58024 L
.85995 .58689 L
.89979 .59172 L
.93812 .5952 L
.97619 .59777 L
s
.02381 .07365 m
.02499 .07369 L
.02605 .07373 L
.02846 .07386 L
.03068 .07401 L
.03279 .07419 L
.0375 .07472 L
.04262 .07547 L
.05293 .07756 L
.06244 .08018 L
.0829 .088 L
.10458 .09944 L
.14241 .12657 L
.1827 .16403 L
.22147 .20635 L
.2627 .25551 L
.30241 .30435 L
.3406 .35053 L
.38125 .39686 L
.42038 .43733 L
.46196 .47493 L
.50202 .50548 L
.54057 .52967 L
.58158 .55019 L
.62107 .56545 L
.65904 .57661 L
.69946 .58539 L
.73837 .59145 L
.75961 .59397 L
.77973 .59593 L
.81806 .59876 L
.83784 .59985 L
.85884 .60077 L
.89659 .60199 L
.91594 .60244 L
.9368 .60282 L
.95599 .60309 L
.97619 .60332 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003ooooooolQ
ooooo`00Aoooool3o`00033ooooo1Ol0000_ooooo`?o0000<_ooool3o`00033ooooo0ol00007oooo
o`00B?ooool00ol0003oooooooooo`0`ooooo`04o`000?ooooooooooo`0002kooooo00Go0000oooo
ooooooooooooo`00000booooo`03o`000?oooooooooo02kooooo00Go0000ooooooooooooooooo`00
0006ooooo`00B?ooool00ol0003oooooooooo`0aooooo`03o`000?oooooooooo03;ooooo00?o0000
ooooooooool0;Oooool5o`0003?ooooo00?o0000ooooooooool01?ooool004Sooooo00?o0000oooo
ooooool0<_ooool00ol0003oooooooooo`0_ooooo`;o0000<?ooool01?l0003oooooooooool0000d
ooooo`03o`000?oooooooooo00Cooooo0018ooooo`03o`000?oooooooooo02oooooo00Go0000oooo
ooooooooooooo`00000booooo`03o`000?oooooooooo02kooooo00?o0000ooooool00000<?ooool4
o`0000Oooooo0017ooooo`;o0000<Oooool01Ol0003ooooooooooooooooo000002kooooo00Go0000
ooooooooooooooooo`00000aooooo`;o0000<?ooool00ol0003oooooooooo`08ooooo`00B?ooool0
0ol0003oooooooooo`0`ooooo`?o0000<?ooool3o`0003?ooooo00?o0000ooooooooool0;_ooool5
o`0000Kooooo000Eooooo`03o`000?oooooooooo0?oooooo2Oooool001Gooooo00?o0000oooooooo
ool0ooooool9ooooo`005Oooool00ol0003oooooooooo`3oooooo`Wooooo000Eooooo`03o`000?oo
oooooooo0?oooooo2Oooool000ooooooool0000Ao`00007ooooo000Eooooo`03o`000?oooooooooo
00Oooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo
00Sooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo
00Sooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo
00Sooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo
00Sooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo
00Sooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo
00Sooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo
00Sooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo
00Sooooo00?o0000ooooooooool01Oooool001Gooooo00?o0000ooooooooool0<Oooool00ol0003o
ooooooooo`0aooooo`03o`000?oooooooooo033ooooo00?o0000ooooooooool0<Oooool00ol0003o
ooooooooo`0aooooo`03o`000?oooooooooo00Gooooo000Eooooo`03o`000?oooooooooo0?oooooo
2Oooool001Gooooo00?o0000ooooooooool0ooooool9ooooo`005Oooool00ol0003oooooooooo`3o
ooooo`Wooooo000Eooooo`03o`000?oooooooooo0?oooooo2Oooool001Gooooo00?o0000oooooooo
ool0ooooool9ooooo`005Oooool2o`000?oooooo2_ooool001Gooooo00?o0000ooooooooool0oooo
ool9ooooo`005Oooool00ol0003oooooooooo`3oooooo`Wooooo000Eooooo`03o`000?oooooooooo
0?oooooo2Oooool001Gooooo00?o0000ooooooooool0ooooool9ooooo`005Oooool00ol0003ooooo
ooooo`3oooooo`Wooooo000Eooooo`03o`000?oooooooooo0?oooooo2Oooool001Gooooo00?o0000
ooooooooool0ooooool9ooooo`005Oooool8o`000?oooooo1?ooool001Gooooo00?o0000oooooooo
ool01Oooool7o`000?cooooo000Eooooo`03o`000?oooooooooo00Sooooo2?l0003hooooo`005Ooo
ool00ol0003oooooooooo`0:ooooo`Wo0000mOooool001Gooooo00?o0000ooooooooool03Oooool2
o`000003ooooool0003o000000?o0000loooool001Gooooo00?o0000ooooooooool03oooool2o`00
00;ooooo1Ol0003`ooooo`005Oooool00ol0003oooooooooo`0Aooooo`;o00000_ooool2o`000004
ooooool0003o0000o`000>gooooo000Eooooo`03o`000?oooooooooo01?ooooo0_l00002ooooo`?o
000000Coooooo`000?l0003o0000j_ooool001Gooooo0_l0000Fooooo`03o`000?oooooooooo00;o
oooo0_l00002ooooo`;o0000j?ooool001Gooooo00?o0000ooooooooool05_ooool2o`0000Cooooo
0_l00002ooooo`;o0000i_ooool001Gooooo00?o0000ooooooooool06?ooool00ol0003ooooooooo
o`03ooooo`;o00000_ooool2o`000>Cooooo000Eooooo`03o`000?oooooooooo01Wooooo00?o0000
ooooooooool01?ooool01Ol0003ooooooooooooooooo00000>?ooooo000Eooooo`03o`000?oooooo
oooo01[ooooo0_l00005ooooo`;o00000_ooool2o`000>7ooooo0002ooooo`;o00001?ooool01?l0
003oooooooooooooool5o`0000Cooooo00?o0000ooooooooool07?ooool00ol0003oooooooooo`04
ooooo`;o00000_ooool2o`000=oooooo00001Ooooooo0000oooooooooooo000000Sooooo00Co0000
oooooooooooo00001?ooool00ol0003oooooooooo`0Mooooo`03o`000?oooooooooo00Gooooo00Co
0000oooooooooooooooo0_l0003Mooooo`0000Goooooo`000?ooooooooooo`000009ooooo`03o`00
0?oooooooooo00Cooooo00?o0000ooooooooool07_ooool00ol0003oooooooooo`05ooooo`;o0000
0oooool2o`000=_ooooo00001Ooooooo0000oooooooooooo000000[ooooo00?o0000ooooooooool0
0oooool3o`0001oooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`02ooooo`03o`00
0?oooooooooo0=Sooooo00001Ooooooo0000oooooooooooo000000Oooooo00Go0000oooooooooooo
ooooo`000004ooooo`03o`000?oooooooooo023ooooo00?o0000ooooooooool01_ooool2o`0000?o
oooo0_l0003Hooooo`0000Goooooo`000?ooooooooooo`000007ooooo`05o`000?oooooooooooooo
ool000001?ooool00ol0003oooooooooo`0Qooooo`03o`000?oooooooooo00Oooooo00?o0000oooo
ooooool00_ooool2o`000=Kooooo0002ooooo`;o00002Oooool3o`0000Gooooo00?o0000oooooooo
ool08_ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00?ooooo00?o0000oooooooo
ool0doooool001Gooooo00?o0000ooooooooool08oooool00ol0003oooooooooo`07ooooo`03o`00
0?oooooooooo00?ooooo0_l0003Cooooo`005Oooool00ol0003oooooooooo`0Tooooo`03o`000?oo
oooooooo00Oooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`3@ooooo`005Oooool0
0ol0003oooooooooo`0Uooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool01?ooool0
0ol0003oooooooooo`3?ooooo`005Oooool00ol0003oooooooooo`0Vooooo`03o`000?oooooooooo
00Oooooo00?o0000ooooooooool01?ooool2o`000<oooooo000Eooooo`;o0000:?ooool00ol0003o
ooooooooo`07ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool0c?ooool001Gooooo
00?o0000ooooooooool0:?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Gooooo
0_l0003<ooooo`005Oooool00ol0003oooooooooo`0Yooooo`03o`000?oooooooooo00Oooooo0_l0
0007ooooo`03o`000?oooooooooo0<Wooooo000Eooooo`03o`000?oooooooooo02[ooooo00?o0000
ooooooooool02?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo0<Sooooo000Eoooo
o`03o`000?oooooooooo02_ooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`05oooo
o`;o0000b?ooool001Gooooo00?o0000ooooooooool0;?ooool00ol0003oooooooooo`08ooooo`03
o`000?oooooooooo00Kooooo00?o0000ooooooooool0aOooool001Gooooo00?o0000ooooooooool0
;Oooool00ol0003oooooooooo`08ooooo`;o00001oooool00ol0003oooooooooo`34ooooo`005Ooo
ool00ol0003oooooooooo`0^ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool01Ooo
ool2o`000<Cooooo000Eooooo`;o0000<?ooool00ol0003oooooooooo`09ooooo`03o`000?oooooo
oooo00Kooooo00?o0000ooooooooool0`Oooool001Gooooo00?o0000ooooooooool0<?ooool00ol0
003oooooooooo`09ooooo`03o`000?oooooooooo00Kooooo0_l00031ooooo`005Oooool00ol0003o
ooooooooo`0aooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool01oooool00ol0003o
ooooooooo`2nooooo`005Oooool00ol0003oooooooooo`0booooo`03o`000?oooooooooo00Wooooo
00?o0000ooooooooool01oooool00ol0003oooooooooo`2mooooo`005Oooool00ol0003ooooooooo
o`0cooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool01oooool2o`000;gooooo000E
ooooo`03o`000?oooooooooo03?ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`08
ooooo`03o`000?oooooooooo0;[ooooo000Eooooo`03o`000?oooooooooo03Cooooo00?o0000oooo
ooooool02_ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo0;Wooooo000Eooooo`03
o`000?oooooooooo03Gooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`08ooooo`03
o`000?oooooooooo0;Sooooo000Eooooo`;o0000=oooool00ol0003oooooooooo`0:ooooo`03o`00
0?oooooooooo00Sooooo00?o0000ooooooooool0]oooool001Gooooo00?o0000ooooooooool0=ooo
ool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool0]_oo
ool001Gooooo00?o0000ooooooooool0>?ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooo
oooo00Sooooo00?o0000ooooooooool0]Oooool001Gooooo00?o0000ooooooooool0>Oooool00ol0
003oooooooooo`0:ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool0]?ooool001Go
oooo00?o0000ooooooooool0>Oooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00So
oooo00?o0000ooooooooool0/oooool000;ooooo0_l00004ooooo`03o`000?oooooooooo00?ooooo
0ol00004ooooo`03o`000?oooooooooo03[ooooo00?o0000ooooooooool02oooool00ol0003ooooo
ooooo`08ooooo`03o`000?oooooooooo0;;ooooo00001Ooooooo0000oooooooooooo000000[ooooo
00?o0000ooooooooool00oooool00ol0003oooooooooo`0kooooo`03o`000?oooooooooo00_ooooo
00?o0000ooooooooool02?ooool2o`000;;ooooo00001Ooooooo0000oooooooooooo000000Oooooo
1Ol00004ooooo`03o`000?oooooooooo03cooooo00?o0000ooooooooool02oooool00ol0003ooooo
ooooo`09ooooo`03o`000?oooooooooo0:oooooo00001Ooooooo0000oooooooooooo000000Oooooo
00Co0000oooooooooooo00001Oooool3o`0003gooooo00?o0000ooooooooool02oooool00ol0003o
ooooooooo`09ooooo`03o`000?oooooooooo0:kooooo00001Ooooooo0000oooooooooooo000000So
oooo00?o0000ooooool000001Oooool00ol0003oooooooooo`0nooooo`03o`000?oooooooooo00_o
oooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`2]ooooo`0000Goooooo`000?oooooo
ooooo`000009ooooo`;o00001Oooool00ol0003oooooooooo`0nooooo`03o`000?oooooooooo00co
oooo00?o0000ooooooooool02Oooool2o`000:gooooo0002ooooo`;o00002oooool00ol0003ooooo
ooooo`03ooooo`03o`000?oooooooooo03oooooo00?o0000ooooooooool03?ooool00ol0003ooooo
ooooo`0:ooooo`03o`000?oooooooooo0:[ooooo000Eooooo`03o`000?oooooooooo043ooooo00?o
0000ooooooooool03?ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo0:Wooooo000E
ooooo`03o`000?oooooooooo047ooooo00?o0000ooooooooool03?ooool00ol0003oooooooooo`0:
ooooo`03o`000?oooooooooo0:Sooooo000Eooooo`03o`000?oooooooooo04;ooooo00?o0000oooo
ooooool03?ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo0:Oooooo000Eooooo`03
o`000?oooooooooo04;ooooo00?o0000ooooooooool03Oooool00ol0003oooooooooo`0:ooooo`03
o`000?oooooooooo0:Kooooo000Eooooo`;o0000A?ooool00ol0003oooooooooo`0=ooooo`03o`00
0?oooooooooo00[ooooo00?o0000ooooooooool0YOooool001Gooooo00?o0000ooooooooool0A?oo
ool00ol0003oooooooooo`0=ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool0Y?oo
ool001Gooooo00?o0000ooooooooool0AOooool00ol0003oooooooooo`0=ooooo`03o`000?oooooo
oooo00[ooooo00?o0000ooooooooool0Xoooool001Gooooo00?o0000ooooooooool0AOooool00ol0
003oooooooooo`0>ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool0X_ooool001Go
oooo00?o0000ooooooooool0A_ooool00ol0003oooooooooo`0>ooooo`03o`000?oooooooooo00[o
oooo00?o0000ooooooooool0XOooool001Gooooo00?o0000ooooooooool0Aoooool00ol0003ooooo
ooooo`0>ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool0X?ooool001Gooooo00?o
0000ooooooooool0B?ooool00ol0003oooooooooo`0>ooooo`03o`000?oooooooooo00[ooooo00?o
0000ooooooooool0Woooool001Gooooo00?o0000ooooooooool0BOooool00ol0003oooooooooo`0>
ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool0W_ooool001Gooooo0_l0001:oooo
o`03o`000?oooooooooo00oooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`2Moooo
o`005Oooool00ol0003oooooooooo`1:ooooo`03o`000?oooooooooo00oooooo00?o0000oooooooo
ool02_ooool2o`0009gooooo000Eooooo`03o`000?oooooooooo04_ooooo00?o0000ooooooooool0
3oooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo09[ooooo000Eooooo`03o`000?oo
oooooooo04cooooo00?o0000ooooooooool03oooool00ol0003oooooooooo`0;ooooo`03o`000?oo
oooooooo09Wooooo000Eooooo`03o`000?oooooooooo04gooooo00?o0000ooooooooool03oooool0
0ol0003oooooooooo`0;ooooo`03o`000?oooooooooo09Sooooo000Eooooo`03o`000?oooooooooo
04kooooo00?o0000ooooooooool03oooool00ol0003oooooooooo`0;ooooo`;o0000V?ooool001Go
oooo00?o0000ooooooooool0C_ooool00ol0003oooooooooo`0@ooooo`03o`000?oooooooooo00co
oooo00?o0000ooooooooool0UOooool001Gooooo00?o0000ooooooooool0Coooool00ol0003ooooo
ooooo`0@ooooo`03o`000?oooooooooo00cooooo00?o0000ooooooooool0U?ooool001Gooooo0_l0
001Aooooo`03o`000?oooooooooo013ooooo00?o0000ooooooooool03?ooool00ol0003ooooooooo
o`2Cooooo`005Oooool00ol0003oooooooooo`1Aooooo`03o`000?oooooooooo013ooooo00?o0000
ooooooooool03?ooool00ol0003oooooooooo`2Booooo`005Oooool00ol0003oooooooooo`1Boooo
o`03o`000?oooooooooo013ooooo00?o0000ooooooooool03?ooool2o`0009;ooooo000Eooooo`03
o`000?oooooooooo05?ooooo00?o0000ooooooooool04?ooool00ol0003oooooooooo`0=ooooo`03
o`000?oooooooooo08oooooo000Eooooo`03o`000?oooooooooo05?ooooo00?o0000ooooooooool0
4Oooool00ol0003oooooooooo`0=ooooo`03o`000?oooooooooo08kooooo0002ooooo`;o00001?oo
ool00ol0003oooooooooo`02ooooo`?o00001Oooool00ol0003oooooooooo`1Dooooo`03o`000?oo
oooooooo017ooooo00?o0000ooooooooool03Oooool00ol0003oooooooooo`2=ooooo`0000Gooooo
o`000?ooooooooooo`000007ooooo`05o`000?ooooooooooooooool000001?ooool00ol0003ooooo
ooooo`1Eooooo`03o`000?oooooooooo017ooooo0_l0000>ooooo`;o0000SOooool00005ooooool0
003oooooooooool000001oooool01Ol0003ooooooooooooooooo000000Cooooo00?o0000oooooooo
ool0E_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo00gooooo00?o0000oooooooo
ool0R_ooool00005ooooool0003oooooooooool000001oooool4o`0000Gooooo0ol0001Gooooo`03
o`000?oooooooooo01;ooooo00?o0000ooooooooool03Oooool00ol0003oooooooooo`29ooooo`00
00Goooooo`000?ooooooooooo`000007ooooo`03o`000?oooooooooo00Kooooo00?o0000oooooooo
ool0F?ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo00gooooo00?o0000oooooooo
ool0R?ooool00005ooooool0003oooooooooool000002?ooool00ol0003oooooooooo`05ooooo`03
o`000?oooooooooo05Wooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`0=ooooo`03
o`000?oooooooooo08Oooooo0002ooooo`;o00002_ooool2o`0000Gooooo00?o0000ooooooooool0
FOooool00ol0003oooooooooo`0Cooooo`03o`000?oooooooooo00gooooo0_l00027ooooo`005Ooo
ool00ol0003oooooooooo`1Jooooo`03o`000?oooooooooo01?ooooo00?o0000ooooooooool03_oo
ool00ol0003oooooooooo`24ooooo`005Oooool00ol0003oooooooooo`1Kooooo`03o`000?oooooo
oooo01?ooooo00?o0000ooooooooool03_ooool00ol0003oooooooooo`23ooooo`005Oooool00ol0
003oooooooooo`1Looooo`03o`000?oooooooooo01?ooooo00?o0000ooooooooool03_ooool00ol0
003oooooooooo`22ooooo`005Oooool00ol0003oooooooooo`1Mooooo`03o`000?oooooooooo01?o
oooo00?o0000ooooooooool03_ooool2o`0008;ooooo000Eooooo`;o0000Goooool00ol0003ooooo
ooooo`0Cooooo`;o00004?ooool00ol0003oooooooooo`1oooooo`005Oooool00ol0003ooooooooo
o`1Oooooo`03o`000?oooooooooo01Cooooo00?o0000ooooooooool03_ooool00ol0003ooooooooo
o`1nooooo`005Oooool00ol0003oooooooooo`1Pooooo`03o`000?oooooooooo01Cooooo00?o0000
ooooooooool03_ooool00ol0003oooooooooo`1mooooo`005Oooool00ol0003oooooooooo`1Qoooo
o`03o`000?oooooooooo01Cooooo00?o0000ooooooooool03_ooool00ol0003oooooooooo`1loooo
o`005Oooool00ol0003oooooooooo`1Rooooo`03o`000?oooooooooo01Cooooo0_l0000?ooooo`;o
0000O?ooool001Gooooo00?o0000ooooooooool0Hoooool00ol0003oooooooooo`0Eooooo`03o`00
0?oooooooooo00kooooo00?o0000ooooooooool0NOooool001Gooooo00?o0000ooooooooool0I?oo
ool00ol0003oooooooooo`0Eooooo`03o`000?oooooooooo00kooooo00?o0000ooooooooool0N?oo
ool001Gooooo00?o0000ooooooooool0IOooool00ol0003oooooooooo`0Eooooo`03o`000?oooooo
oooo00kooooo0_l0001hooooo`005Oooool2o`0006Oooooo00?o0000ooooooooool05Oooool00ol0
003oooooooooo`0?ooooo`03o`000?oooooooooo07Gooooo000Eooooo`03o`000?oooooooooo06Oo
oooo00?o0000ooooooooool05Oooool2o`00013ooooo0_l0001eooooo`005Oooool00ol0003ooooo
ooooo`1Xooooo`03o`000?oooooooooo01Kooooo00?o0000ooooooooool03oooool00ol0003ooooo
ooooo`1booooo`005Oooool00ol0003oooooooooo`1Yooooo`;o00005oooool00ol0003ooooooooo
o`0?ooooo`03o`000?oooooooooo077ooooo000Eooooo`03o`000?oooooooooo06_ooooo00?o0000
ooooooooool05Oooool00ol0003oooooooooo`0?ooooo`;o0000LOooool001Gooooo00?o0000oooo
ooooool0K?ooool00ol0003oooooooooo`0Eooooo`;o00004Oooool00ol0003oooooooooo`1^oooo
o`005Oooool00ol0003oooooooooo`1]ooooo`03o`000?oooooooooo01Kooooo00?o0000oooooooo
ool03oooool2o`0006kooooo000Eooooo`03o`000?oooooooooo06kooooo00?o0000ooooooooool0
5_ooool00ol0003oooooooooo`0@ooooo`03o`000?oooooooooo06_ooooo000Eooooo`;o0000L?oo
ool00ol0003oooooooooo`0Fooooo`03o`000?oooooooooo013ooooo00?o0000ooooooooool0J_oo
ool001Gooooo00?o0000ooooooooool0L?ooool00ol0003oooooooooo`0Fooooo`03o`000?oooooo
oooo013ooooo0_l0001Zooooo`005Oooool00ol0003oooooooooo`1aooooo`03o`000?oooooooooo
01Kooooo0_l0000Booooo`03o`000?oooooooooo06Oooooo000Eooooo`03o`000?oooooooooo07;o
oooo00?o0000ooooooooool05oooool00ol0003oooooooooo`0@ooooo`;o0000Ioooool001Gooooo
00?o0000ooooooooool0Loooool00ol0003oooooooooo`0Gooooo`;o00004_ooool2o`0006Gooooo
0002ooooo`;o00001?ooool00ol0003oooooooooo`02ooooo`?o00001Oooool00ol0003ooooooooo
o`1dooooo`;o00006Oooool2o`0001;ooooo0_l0001Sooooo`0000Goooooo`000?ooooooooooo`00
0007ooooo`05o`000?ooooooooooooooool000001?ooool00ol0003oooooooooo`1fooooo`03o`00
0?oooooooooo01Sooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`1Pooooo`0000Go
ooooo`000?ooooooooooo`000007ooooo`05o`000?ooooooooooooooool000001?ooool00ol0003o
ooooooooo`1gooooo`03o`000?oooooooooo01Sooooo0_l0000Booooo`;o0000H?ooool00005oooo
ool0003oooooooooool000002?ooool3o`0000Gooooo0ol0001hooooo`;o00006_ooool00ol0003o
ooooooooo`0Aooooo`;o0000G_ooool00005ooooool0003oooooooooool000001oooool01Ol0003o
oooooooooooooooo000000Cooooo00?o0000ooooooooool0N_ooool00ol0003oooooooooo`0Hoooo
o`;o00004oooool2o`0005cooooo00001Ooooooo0000oooooooooooo000000Oooooo00Go0000oooo
ooooooooooooo`000004ooooo`03o`000?oooooooooo07_ooooo0_l0000Jooooo`;o00004oooool2
o`0005[ooooo0002ooooo`;o00002Oooool3o`0000Gooooo00?o0000ooooooooool0OOooool00ol0
003oooooooooo`0Iooooo`03o`000?oooooooooo01;ooooo0_l0001Hooooo`005Oooool00ol0003o
ooooooooo`1nooooo`03o`000?oooooooooo01Wooooo0_l0000Dooooo`03o`000?oooooooooo05Go
oooo000Eooooo`03o`000?oooooooooo07oooooo0_l0000Kooooo`;o00004oooool2o`0005Gooooo
000Eooooo`03o`000?oooooooooo087ooooo00?o0000ooooooooool06_ooool00ol0003ooooooooo
o`0Booooo`;o0000Doooool001Gooooo00?o0000ooooooooool0P_ooool2o`0001_ooooo0_l0000D
ooooo`;o0000DOooool001Gooooo0_l00025ooooo`03o`000?oooooooooo01[ooooo0_l0000Doooo
o`?o0000C_ooool001Gooooo00?o0000ooooooooool0QOooool00ol0003oooooooooo`0Kooooo`;o
00005Oooool2o`0004cooooo000Eooooo`03o`000?oooooooooo08Kooooo0_l0000Mooooo`03o`00
0?oooooooooo01Cooooo0ol00019ooooo`005Oooool00ol0003oooooooooo`28ooooo`03o`000?oo
oooooooo01_ooooo0_l0000Gooooo`;o0000Aoooool001Gooooo00?o0000ooooooooool0ROooool2
o`0001gooooo0_l0000Gooooo`?o0000A?ooool001Gooooo00?o0000ooooooooool0Roooool3o`00
01cooooo0_l0000Hooooo`?o0000@Oooool001Gooooo00?o0000ooooooooool0S_ooool2o`0001co
oooo0ol0000Hooooo`?o0000?_ooool001Gooooo00?o0000ooooooooool0T?ooool2o`0001gooooo
0ol0000Hooooo`;o0000??ooool001Gooooo0_l0002Cooooo`?o00007Oooool3o`0001Oooooo0ol0
000iooooo`005Oooool00ol0003oooooooooo`2Eooooo`;o00007_ooool3o`0001Oooooo0ol0000f
ooooo`005Oooool00ol0003oooooooooo`2Gooooo`;o00007oooool3o`0001Oooooo0ol0000coooo
o`005Oooool00ol0003oooooooooo`2Iooooo`;o00008?ooool3o`0001Oooooo0ol0000`ooooo`00
5Oooool00ol0003oooooooooo`2Kooooo`;o00008Oooool4o`0001Kooooo1?l0000/ooooo`005Ooo
ool00ol0003oooooooooo`2Mooooo`;o00008oooool4o`0001Kooooo0ol0000Yooooo`005Oooool0
0ol0003oooooooooo`2Oooooo`?o00009?ooool3o`0001Kooooo1Ol0000Tooooo`005Oooool00ol0
003oooooooooo`2Rooooo`Co00008oooool4o`0001Oooooo1Ol0000Oooooo`005Oooool2o`000:Oo
oooo0ol0000Tooooo`Co00006?ooool6o`0001Wooooo000Eooooo`03o`000?oooooooooo0:Wooooo
1Ol0000Sooooo`?o00006oooool5o`0001Cooooo000Eooooo`03o`000?oooooooooo0:kooooo1Ol0
000Qooooo`So00006?ooool8o`0000cooooo000Eooooo`03o`000?oooooooooo0;?ooooo1_l0000S
ooooo`So00006?ooool5o`0000Oooooo000Eooooo`03o`000?oooooooooo0;Wooooo1Ol0000Voooo
o`Go00007oooool000gooooo0ol00005ooooo`03o`000?oooooooooo0;kooooo2ol0000Pooooo`So
00005oooool000kooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`39ooooo`So0000
8?ooool@o`0000Oooooo000>ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool0dOoo
oolMo`0001[ooooo000>ooooo`03o`000?oooooooooo00Cooooo0ol0003^oooooa?o00001oooool0
00kooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`3oooooo`Wooooo000=ooooo`;o
00001_ooool00ol0003oooooooooo`3oooooo`Wooooo000>ooooo`03o`000?oooooooooo00Cooooo
00?o0000ooooooooool0ooooool9ooooo`005Oooool00ol0003oooooooooo`3oooooo`Wooooo0000
\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.418454, -0.0774421, \
0.0193321, 0.0062483}}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Ex. 4.14", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NIntegrate[
      200 \( Exp[0.32  t] - 1\)\/\(Exp[0.32  t] + 1\), {t, 0, 
        9.2}]\)], "Input"],

Cell[BoxData[
    \(1037.7100842039395`\)], "Output"]
}, Closed]]
}, Closed]]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"4.2 for Macintosh",
ScreenRectangle->{{4, 1024}, {0, 746}},
WindowSize->{520, 624},
WindowMargins->{{33, Automatic}, {Automatic, 12}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 113, 4, 83, "Subtitle"],

Cell[CellGroupData[{
Cell[1914, 61, 32, 0, 56, "Section"],

Cell[CellGroupData[{
Cell[1971, 65, 29, 0, 46, "Subsection"],

Cell[CellGroupData[{
Cell[2025, 69, 126, 2, 62, "Input"],
Cell[2154, 73, 242, 4, 113, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[2433, 82, 69, 1, 24, "Input"],
Cell[2505, 85, 84, 1, 44, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[2626, 91, 117, 2, 39, "Input"],
Cell[2746, 95, 38, 1, 27, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[2821, 101, 52, 1, 24, "Input"],
Cell[2876, 104, 38, 1, 27, "Output"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[2975, 112, 32, 0, 36, "Section"],
Cell[3010, 114, 41, 1, 27, "Input"],

Cell[CellGroupData[{
Cell[3076, 119, 148, 2, 62, "Input"],
Cell[3227, 123, 271, 7, 27, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[3535, 135, 92, 1, 24, "Input"],
Cell[3630, 138, 17148, 428, 186, 3676, 257, "GraphicsData", "PostScript", \
"Graphics"]
}, Closed]],

Cell[CellGroupData[{
Cell[20815, 571, 31, 0, 30, "Subsection"],

Cell[CellGroupData[{
Cell[20871, 575, 147, 2, 62, "Input"],
Cell[21021, 579, 271, 7, 27, "Output"]
}, Closed]],
Cell[21307, 589, 92, 1, 24, "Input"],

Cell[CellGroupData[{
Cell[21424, 594, 147, 2, 62, "Input"],
Cell[21574, 598, 271, 7, 27, "Output"]
}, Closed]],
Cell[21860, 608, 92, 1, 24, "Input"],

Cell[CellGroupData[{
Cell[21977, 613, 147, 2, 62, "Input"],
Cell[22127, 617, 271, 7, 27, "Output"]
}, Closed]],
Cell[22413, 627, 92, 1, 24, "Input"],

Cell[CellGroupData[{
Cell[22530, 632, 54, 1, 27, "Input"],
Cell[22587, 635, 23686, 560, 186, 4649, 320, "GraphicsData", "PostScript", \
"Graphics"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[46322, 1201, 30, 0, 30, "Subsection"],

Cell[CellGroupData[{
Cell[46377, 1205, 121, 3, 44, "Input"],
Cell[46501, 1210, 53, 1, 27, "Output"]
}, Closed]]
}, Closed]]
}, Closed]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

